/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import javax.imageio.ImageIO;
import lombok.NonNull;
import net.ftb.data.Settings;
import net.ftb.download.Locations;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.LoadingDialog;
import net.ftb.log.Logger;
import net.ftb.util.Benchmark;
import org.apache.commons.io.IOUtils;

public class DownloadUtils
extends Thread {
    public static String getCreeperhostLink(String file) {
        String resolved = Locations.downloadServers.containsKey(Settings.getSettings().getDownloadServer()) ? "http://" + Locations.downloadServers.get(Settings.getSettings().getDownloadServer()) : Locations.masterRepo;
        resolved = resolved + "/FTB2/" + file;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(resolved).openConnection();
            connection.setRequestProperty("Cache-Control", "no-transform");
            connection.setRequestMethod("HEAD");
            for (String server : Locations.downloadServers.values()) {
                if (connection.getResponseCode() != 200) {
                    if (!server.contains("creeper")) {
                        file = file.replaceAll("%5E", "/");
                    }
                    resolved = "http://" + server + "/FTB2/" + file;
                    connection = (HttpURLConnection)new URL(resolved).openConnection();
                    connection.setRequestProperty("Cache-Control", "no-transform");
                    connection.setRequestMethod("HEAD");
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        connection.disconnect();
        return resolved;
    }

    public static String getStaticCreeperhostLinkOrBackup(String file, String backupLink) {
        boolean good;
        HttpURLConnection connection;
        String resolved;
        block8: {
            resolved = Locations.downloadServers.containsKey(Settings.getSettings().getDownloadServer()) ? "http://" + Locations.downloadServers.get(Settings.getSettings().getDownloadServer()) : Locations.masterRepo;
            resolved = resolved + "/FTB2/static/" + file;
            connection = null;
            good = false;
            try {
                connection = (HttpURLConnection)new URL(resolved).openConnection();
                connection.setRequestProperty("Cache-Control", "no-transform");
                connection.setRequestMethod("HEAD");
                if (connection.getResponseCode() != 200) {
                    for (String server : Locations.downloadServers.values()) {
                        if (connection.getResponseCode() != 200) {
                            resolved = "http://" + server + "/FTB2/static/" + file;
                            connection = (HttpURLConnection)new URL(resolved).openConnection();
                            connection.setRequestProperty("Cache-Control", "no-transform");
                            connection.setRequestMethod("HEAD");
                            continue;
                        }
                        if (connection.getResponseCode() == 200) {
                            good = true;
                        }
                        break block8;
                    }
                    break block8;
                }
                if (connection.getResponseCode() == 200) {
                    good = true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        connection.disconnect();
        if (good) {
            return resolved;
        }
        Logger.logWarn("Using backupLink for " + file);
        return backupLink;
    }

    public static String getStaticCreeperhostLink(String file) {
        HttpURLConnection connection;
        String resolved;
        block4: {
            resolved = Locations.downloadServers.containsKey(Settings.getSettings().getDownloadServer()) ? "http://" + Locations.downloadServers.get(Settings.getSettings().getDownloadServer()) : Locations.masterRepo;
            resolved = resolved + "/FTB2/static/" + file;
            connection = null;
            try {
                connection = (HttpURLConnection)new URL(resolved).openConnection();
                connection.setRequestProperty("Cache-Control", "no-transform");
                connection.setRequestMethod("HEAD");
                if (connection.getResponseCode() == 200) break block4;
                for (String server : Locations.downloadServers.values()) {
                    if (connection.getResponseCode() != 200) {
                        resolved = "http://" + server + "/FTB2/static/" + file;
                        connection = (HttpURLConnection)new URL(resolved).openConnection();
                        connection.setRequestProperty("Cache-Control", "no-transform");
                        connection.setRequestMethod("HEAD");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        connection.disconnect();
        return resolved;
    }

    public static boolean staticFileExists(String file) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(DownloadUtils.getStaticCreeperhostLink(file)).openConnection();
            connection.setRequestProperty("Cache-Control", "no-transform");
            connection.setRequestMethod("HEAD");
            return connection.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean fileExists(String file) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(Locations.masterRepo + "/FTB2/" + file).openConnection();
            connection.setRequestProperty("Cache-Control", "no-transform");
            connection.setRequestMethod("HEAD");
            return connection.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean CloudFlareInspector(String repoURL, boolean fullDebug) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(repoURL + "cdn-cgi/trace").openConnection();
            if (!fullDebug) {
                connection.setRequestMethod("HEAD");
            }
            Logger.logInfo("CF-RAY: " + connection.getHeaderField("CF-RAY"));
            if (fullDebug) {
                Logger.logInfo("CF Debug Info: " + connection.getContent().toString());
            }
            boolean ret = connection.getResponseCode() == 200;
            IOUtils.close(connection);
            return ret;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void downloadToFile(String filename, String urlString) throws IOException {
        DownloadUtils.downloadToFile(new URL(urlString), new File(filename));
    }

    public static void downloadToFile(URL url, File file) throws IOException {
        file.getParentFile().mkdirs();
        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
        FileOutputStream fos = new FileOutputStream(file);
        fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
        fos.close();
    }

    public static void downloadToFile(URL url, File file, int attempts) {
        int attempt = 0;
        boolean success = false;
        Exception reason = null;
        while (attempt < attempts && !success) {
            try {
                success = true;
                DownloadUtils.downloadToFile(url, file);
            }
            catch (Exception e) {
                success = false;
                reason = e;
                ++attempt;
            }
            if (attempt != attempts || success) continue;
            Logger.logError("library JSON download failed", reason);
            return;
        }
    }

    public static void saveImage(String file, File location, String type) {
        if (DownloadUtils.staticFileExists(file)) {
            try {
                URL url_ = new URL(DownloadUtils.getStaticCreeperhostLink(file));
                BufferedImage tempImg = ImageIO.read(url_);
                ImageIO.write((RenderedImage)tempImg, type, new File(location, file));
                tempImg.flush();
            }
            catch (IOException e) {
                Logger.logWarn("image download/save failed", e);
                new File(location, file).delete();
            }
        }
    }

    public static boolean isValid(File file, String md5) throws IOException {
        String result = DownloadUtils.fileMD5(file);
        Logger.logInfo("Local: " + result.toUpperCase());
        Logger.logInfo("Remote: " + md5.toUpperCase());
        return md5.equalsIgnoreCase(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean backupIsValid(File file, String url) throws IOException {
        String content;
        block8: {
            Logger.logInfo("Issue with new md5 method, attempting to use backup method.");
            content = null;
            Scanner scanner = null;
            String resolved = Locations.downloadServers.containsKey(Settings.getSettings().getDownloadServer()) ? "http://" + Locations.downloadServers.get(Settings.getSettings().getDownloadServer()) : Locations.masterRepo;
            resolved = resolved + "/md5/FTB2/" + url;
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URL(resolved).openConnection();
                connection.setRequestProperty("Cache-Control", "no-transform");
                int response = connection.getResponseCode();
                if (response == 200) {
                    scanner = new Scanner(connection.getInputStream());
                    scanner.useDelimiter("\\Z");
                    content = scanner.next();
                }
                if (response == 200 && content != null && !content.isEmpty()) break block8;
                for (String server : Locations.backupServers.values()) {
                    resolved = "http://" + server + "/md5/FTB2/" + url.replace("/", "%5E");
                    connection = (HttpURLConnection)new URL(resolved).openConnection();
                    connection.setRequestProperty("Cache-Control", "no-transform");
                    response = connection.getResponseCode();
                    if (response != 200) continue;
                    scanner = new Scanner(connection.getInputStream());
                    scanner.useDelimiter("\\Z");
                    content = scanner.next();
                    if (content == null || content.isEmpty()) continue;
                    break;
                }
            }
            catch (IOException e) {
            }
            finally {
                connection.disconnect();
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        String result = DownloadUtils.fileMD5(file);
        Logger.logInfo("Local: " + result.toUpperCase());
        Logger.logInfo("Remote: " + content.toUpperCase());
        return content.equalsIgnoreCase(result);
    }

    public static String fileMD5(File file) throws IOException {
        if (file.exists()) {
            return Files.hash(file, Hashing.md5()).toString();
        }
        return "";
    }

    public static String fileSHA(File file) throws IOException {
        if (file.exists()) {
            return Files.hash(file, Hashing.sha1()).toString();
        }
        return "";
    }

    public static String fileHash(File file, String type) throws IOException {
        int readLen;
        if (!file.exists()) {
            return "";
        }
        if (type.equalsIgnoreCase("md5")) {
            return DownloadUtils.fileMD5(file);
        }
        if (type.equalsIgnoreCase("sha1")) {
            return DownloadUtils.fileSHA(file);
        }
        URL fileUrl = file.toURI().toURL();
        MessageDigest dgest = null;
        try {
            dgest = MessageDigest.getInstance(type);
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        InputStream str = fileUrl.openStream();
        byte[] buffer = new byte[65536];
        while ((readLen = str.read(buffer, 0, buffer.length)) != -1) {
            dgest.update(buffer, 0, readLen);
        }
        str.close();
        Formatter fmt = new Formatter();
        for (byte b : dgest.digest()) {
            fmt.format("%02X", b);
        }
        String result = fmt.toString();
        fmt.close();
        return result;
    }

    @Override
    public void run() {
        this.setName("DownloadUtils");
        if (!Locations.hasDLInitialized) {
            Benchmark.start("DlUtils");
            Logger.logInfo("DownloadUtils.run() starting");
            Locations.downloadServers.put("Automatic", Locations.masterRepoNoHTTP);
            Random r = new Random();
            double choice = r.nextDouble();
            try {
                try {
                    String json = IOUtils.toString(new URL(Locations.masterRepo + "/FTB2/static/balance.json"));
                    JsonElement element = new JsonParser().parse(json);
                    if (element != null && element.isJsonObject()) {
                        JsonObject jso = element.getAsJsonObject();
                        if (jso != null && jso.get("minUsableLauncherVersion") != null) {
                            LaunchFrame.getInstance();
                            LaunchFrame.minUsable = jso.get("minUsableLauncherVersion").getAsInt();
                        }
                        if (jso != null && jso.get("chEnabled") != null) {
                            Locations.chEnabled = jso.get("chEnabled").getAsBoolean();
                        }
                        if (jso != null && jso.get("repoSplitCurse") != null) {
                            JsonElement e = jso.get("repoSplitCurse");
                            Logger.logDebug("Balance Settings: " + e.getAsDouble() + " > " + choice);
                            if (e != null && e.getAsDouble() > choice) {
                                Logger.logInfo("Balance has selected Automatic:CurseCDN");
                            } else {
                                Logger.logInfo("Balance has selected Automatic:CreeperRepo");
                                Locations.masterRepoNoHTTP = "http://new.creeperrepo.net".replaceAll("http://", "");
                                Locations.masterRepo = "http://new.creeperrepo.net";
                                Locations.primaryCH = true;
                                Locations.downloadServers.remove("Automatic");
                                Locations.downloadServers.put("Automatic", Locations.masterRepoNoHTTP);
                            }
                        }
                    }
                    Benchmark.logBenchAs("DlUtils", "Download Utils Bal");
                    if (Locations.chEnabled) {
                        this.parseJSONtoMap(new URL("http://new.creeperrepo.net/edges.json"), "CH", Locations.downloadServers, false, "edges.json");
                        Benchmark.logBenchAs("DlUtils", "Download Utils CH");
                    }
                    this.parseJSONtoMap(new URL("http://ftb.cursecdn.com/edges.json"), "Curse", Locations.downloadServers, false, "edges.json");
                    Benchmark.logBenchAs("DlUtils", "Download Utils Curse");
                    LoadingDialog.setProgress(80);
                }
                catch (IOException e) {
                    int i = 10;
                    Locations.downloadServers.clear();
                    Logger.logInfo("Primary mirror failed, Trying alternative mirrors");
                    LoadingDialog.setProgress(i);
                    this.parseJSONtoMap(this.getClass().getResource("/edges.json"), "Backup", Locations.downloadServers, true, "edges.json");
                }
                LoadingDialog.setProgress(90);
                if (Locations.downloadServers.size() == 0) {
                    Logger.logError("Could not find any working mirrors! If you are running a software firewall please allow the FTB Launcher permission to use the internet.");
                    Locations.downloadServers.put("Automatic", Locations.masterRepoNoHTTP);
                } else if (!Locations.downloadServers.containsKey("Automatic")) {
                    int index = (int)(Math.random() * (double)Locations.downloadServers.size());
                    ArrayList<String> keys = Lists.newArrayList(Locations.downloadServers.keySet());
                    String defaultServer = Locations.downloadServers.get(keys.get(index));
                    Locations.downloadServers.put("Automatic", defaultServer);
                    Logger.logInfo("Selected " + (String)keys.get(index) + " mirror for Automatic assignment");
                }
            }
            catch (Exception e) {
                Logger.logError("Error while selecting server", e);
                Locations.downloadServers.clear();
                Locations.downloadServers.put("Automatic", Locations.masterRepoNoHTTP);
            }
            LoadingDialog.setProgress(100);
            Locations.serversLoaded = true;
            Logger.logInfo("DL ready");
            String selectedMirror = Settings.getSettings().getDownloadServer();
            String selectedHost = Locations.downloadServers.get(selectedMirror);
            String resolvedIP = "UNKNOWN";
            String resolvedHost = "UNKNOWN";
            String resolvedMirror = "UNKNOWN";
            try {
                InetAddress ipAddress = InetAddress.getByName(selectedHost);
                resolvedIP = ipAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                Logger.logError("Failed to resolve selected mirror: " + e.getMessage());
            }
            try {
                for (String key : Locations.downloadServers.keySet()) {
                    InetAddress host;
                    if (key.equals("Automatic") || !resolvedIP.equalsIgnoreCase((host = InetAddress.getByName(Locations.downloadServers.get(key))).getHostAddress())) continue;
                    resolvedMirror = key;
                    resolvedHost = Locations.downloadServers.get(key);
                    break;
                }
            }
            catch (UnknownHostException e) {
                Logger.logError("Failed to resolve mirror: " + e.getMessage());
            }
            Logger.logInfo("Using download server " + selectedMirror + ":" + resolvedMirror + " on host " + resolvedHost + " (" + resolvedIP + ")");
            Benchmark.logBenchAs("DlUtils", "Download Utils Init");
        }
        Locations.hasDLInitialized = true;
    }

    @NonNull
    public void parseJSONtoMap(URL u, String name, HashMap<String, String> h, boolean testEntries, String location) {
        block7: {
            try {
                String json = IOUtils.toString(u);
                JsonElement element = new JsonParser().parse(json);
                int i = 10;
                if (!element.isJsonObject()) break block7;
                JsonObject jso = element.getAsJsonObject();
                for (Map.Entry<String, JsonElement> e : jso.entrySet()) {
                    if (testEntries) {
                        try {
                            Logger.logInfo("Testing Server:" + e.getKey());
                            IOUtils.toString(new URL("http://" + e.getValue().getAsString() + "/" + location));
                            h.put(e.getKey(), e.getValue().getAsString());
                        }
                        catch (Exception ex) {
                            Logger.logWarn((e.getValue().getAsString().contains("creeper") ? "CreeperHost" : "Curse") + " Server: " + e.getKey() + " was not accessible, ignoring." + ex.getMessage());
                        }
                        if (i < 90) {
                            i += 10;
                        }
                        LoadingDialog.setProgress(i);
                        continue;
                    }
                    h.put(e.getKey(), e.getValue().getAsString());
                }
            }
            catch (Exception e2) {
                Logger.logError("Error parsing JSON " + name + " " + location, e2);
            }
        }
    }
}

